︠65e699b4-7390-4927-92b3-c162ce7de015s︠
f(x) = x^2 -1

def myIntegralPlot( a, b ):
    epsilon = 10^-12

    # this takes care of several different drawing issues
    # whenever b < a, or in other words, the bounds are backwards.
    left_bound = min( a, b )
    right_bound = max( a, b )

    # the 10^-12 in the next line might surprise you, but it is because the
    # program reacted badly when both a=1 and b=1.
    P1 = plot( f(x), x, left_bound, right_bound + epsilon, fill=True )
    P2 = plot( f(x), x, -2, 2, gridlines='minor', ymin=-2, ymax=3)
    P3 = text("$\\int_a^b ( x^2 - 1 ) \\; dx$", (0, -1.75), fontsize=24 )

    # this colored arrow avoids student confusion when bounds are backwards
    if (a < b):
        P4 = arrow( (-0.5, 0.99), (0.5, 1), color='green' )
        P = P4 + P1 + P2 + P3
    elif (b < a):
        P4 = arrow( (0.5, 1), (-0.5, 0.99), color='red' )
        P = P4 + P1 + P2 + P3
    else:
        # note, this is for the a=b case
        P = P1 + P2 + P3


    P.show()

    print()
    print("Final Value", integral( f(x), x, a, b ), end=' ')
    print(" or roughly ", N( integral( f(x), x, a, b) ))

    return

myIntegralPlot( -3/2, 1 )
︡42dccfbc-3a82-4fd5-93ed-9aed2ac73d31︡{"file":{"filename":"/home/user/.sage/temp/project-11f18f4a-0a37-4fd9-8ae3-3a7070445f24/587/tmp_wfmie_uc.svg","show":true,"text":null,"uuid":"97195a7b-c79e-49e4-8c47-f5515d32c989"},"once":false}︡{"stdout":"\n"}︡{"stdout":"Final Value"}︡{"stdout":" -25/24  or roughly  -1.04166666666667\n"}︡{"done":true}
︠0c8f979b-bf19-4fe7-ba8e-92b3c5364b66︠

myIntegralPlot( 1/2, 1 )
︡c0bd8744-ed70-4efb-ad2c-9e12ee15d7c8︡{"once":false,"file":{"show":true,"uuid":"317b28bf-83dd-4c1e-9e8b-d2ba3d839954","filename":"/projects/c8ff9ff5-b82e-4e7a-abfa-ee102002f6ca/.sage/temp/compute5dc1/3173/tmp_Xr0GmO.svg"}}︡{"stdout":"\n"}︡{"stdout":"Final Value -5/24  or roughly  -0.208333333333333\n"}︡
︠be8371d6-833a-4111-a287-a4b2a0649e9b︠
myIntegralPlot( -1, 1 )
︡23bfc6df-dfe5-4cd3-8903-b48e5229e977︡{"once":false,"file":{"show":true,"uuid":"bc94a07a-3a2f-4fa8-9258-f375e9db8801","filename":"/projects/c8ff9ff5-b82e-4e7a-abfa-ee102002f6ca/.sage/temp/compute5dc1/3173/tmp_cf7ltZ.svg"}}︡{"stdout":"\n"}︡{"stdout":"Final Value -4/3  or roughly  -1.33333333333333\n"}︡
︠c4d91461-b3d5-40c1-bedf-daf3a79e6263︠
myIntegralPlot( 1, 1 )
︡57b5313b-0b16-4ec7-aa8a-fa45eaf26a94︡{"once":false,"file":{"show":true,"uuid":"a8867377-53aa-470d-b72b-752398e15027","filename":"/projects/c8ff9ff5-b82e-4e7a-abfa-ee102002f6ca/.sage/temp/compute5dc1/3173/tmp_cLOvIt.svg"}}︡{"stdout":"\n"}︡{"stdout":"Final Value 0  or roughly  0.000000000000000\n"}︡
︠2b0770ca-c848-4f4a-b5bf-4293f5862d9e︠
myIntegralPlot( 1, -1 )
︡0ccd3e2b-3462-4f7d-844d-67135c6e093f︡{"once":false,"file":{"show":true,"uuid":"c8f51e18-b8e9-43bd-ade6-21ccc4eff52d","filename":"/projects/c8ff9ff5-b82e-4e7a-abfa-ee102002f6ca/.sage/temp/compute5dc1/3173/tmp_jqd7vl.svg"}}︡{"stdout":"\n"}︡{"stdout":"Final Value 4/3  or roughly  1.33333333333333\n"}︡
︠89f9ce08-f2bf-47b3-a069-d919cb5582a7︠



︡053e5a01-3b70-48ef-9621-2843bfa95452︡
︠d7000418-4a96-4eeb-9633-f2913a3ab4db︠
︡1942dfbd-833e-4777-8a68-36c965e39c26︡
︠04dcee32-029e-497e-abce-e17b2a47cfd4︠
︡fe5e04c9-00ce-4b5a-938a-d91166beb961︡
︠18f2035d-654d-451e-90ea-96803ba5e927︠









